<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AmountCashUserBoxCurrency extends Model 
{

    protected $table = 'amount_cash_users_box_currencies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_box_id', 'currency_id', 'amount', 'status');
    protected $visible = array('user_box_id', 'currency_id', 'amount', 'status');

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

    public function userBox()
    {
        return $this->belongsTo('App\Models\UserBox', 'user_box_id');
    }

    public function amountCashUserBoxCurrency()
    {
        return $this->hasMany('App\Models\AmountCashUserBoxCurrency', 'user_box_id');
    }

}